package com.elitesland.cbpl.bpmn.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefinePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskDefineSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefineDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefinePagingVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskDefineRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
public interface TaskDefineService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TaskDefinePagingVO> taskDefinePageBy(TaskDefinePagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<TaskDefineRespVO> taskDefineByParam(TaskDefineQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    TaskDefineDetailVO taskDefineById(Long id);

    /**
     * 查询当前生效中的流程定义
     *
     * @param id 业务单据ID
     * @return 生效中的版本
     */
    TaskDefineDetailVO effectiveDefineById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(TaskDefineSaveParamVO saveParam);

    /**
     * 启用
     *
     * @param id 业务单据ID
     */
    Long updateStatusV(Long id);

    /**
     * 禁用
     *
     * @param id 业务单据ID
     */
    Long updateStatusX(Long id);

    /**
     * 批量逻辑删除
     *
     * @param ids 业务单据ID
     * @return 更新成功的数量
     */
    long updateDeleteFlag(List<Long> ids);
}
