package com.elitesland.cbpl.bpmn.service;

import com.elitesland.cbpl.bpmn.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.db.PagingVO;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
public interface TaskInstanceService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    TaskInstanceDetailVO taskInstanceById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(TaskInstanceSaveParamVO saveParam);

    /**
     * 更新执行结果
     *
     * @param saveParam 更新参数
     */
    void update(TaskInstanceSaveParamVO saveParam);
}
