package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.TaskInstanceConvert;
import com.elitesland.cbpl.bpmn.entity.TaskInstanceDO;
import com.elitesland.cbpl.bpmn.repo.TaskInstanceRepo;
import com.elitesland.cbpl.bpmn.repo.TaskInstanceRepoProc;
import com.elitesland.cbpl.bpmn.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class TaskInstanceServiceImpl implements TaskInstanceService {

    private final TaskInstanceRepo taskInstanceRepo;
    private final TaskInstanceRepoProc taskInstanceRepoProc;

    @Override
    public PagingVO<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query) {
        long count = taskInstanceRepoProc.taskInstanceCountBy(query);
        if (count > 0) {
            var list = taskInstanceRepoProc.taskInstancePageBy(query);
            return new PagingVO<>(count, list);
        }
        return new PagingVO<>();
    }

    @Override
    public TaskInstanceDetailVO taskInstanceById(Long id) {
        Optional<TaskInstanceDO> taskInstanceDO = taskInstanceRepo.findById(id);
        if (taskInstanceDO.isEmpty()) {
            throw PhoenixException.unexpected("Not Found Data");
        }
        return TaskInstanceConvert.INSTANCE.doToVO(taskInstanceDO.get());
    }

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
    @Override
    public Long save(TaskInstanceSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            TaskInstanceDO taskInstanceDO = TaskInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            taskInstanceRepo.save(taskInstanceDO);
            return taskInstanceDO.getId();
        }
        // 修改
        else {
            Optional<TaskInstanceDO> taskInstanceDO = taskInstanceRepo.findById(saveParam.getId());
            if (taskInstanceDO.isEmpty()) {
                throw PhoenixException.unexpected("Not Found Data");
            }
            TaskInstanceDO taskInstance = taskInstanceDO.get();
            TaskInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, taskInstance);
            taskInstanceRepo.save(taskInstance);
            return taskInstance.getId();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(TaskInstanceSaveParamVO saveParam) {
        taskInstanceRepoProc.update(saveParam);
    }
}
