package com.elitesland.cbpl.bpmn.vo.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.PageQueryParam;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务流程 - 定义表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 定义表")
public class TaskDefinePagingParamVO extends PageQueryParam {

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "任务编码")
	private String taskCode;

	@ApiModelProperty(value = "任务名称")
	private String taskName;

	@ApiModelProperty(value = "任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程")
	private String taskType;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
