package com.elitesland.cbpl.bpmn.vo.param;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 任务流程 - 发布版本表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 发布版本表")
public class TaskVersionPagingParamVO extends PageQueryParam {

	private static final long serialVersionUID = 1264794819437594392L;

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "任务编码")
	@NotBlank(message = "任务编码必填")
	private String taskCode;

	@ApiModelProperty(value = "发布状态：1未发布；2发布成功；3生效中；")
	private Integer status;

	@ApiModelProperty(value = "版本号")
	private Integer version;

	@ApiModelProperty(value = "备注")
	private String remark;
}
