package com.elitesland.cbpl.bpmn.vo.resp;

import com.elitesland.cbpl.bpmn.domain.VersionStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务流程 - 发布版本表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 发布版本表")
public class TaskVersionPagingVO implements Serializable {

	private static final long serialVersionUID = 7502330758448439851L;

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "主表ID")
	private Long masId;

	@ApiModelProperty(value = "任务编码")
	private String taskCode;

	@ApiModelProperty(value = "发布状态：1未发布；2发布成功；3生效中；")
	private Integer status;

	@JsonProperty
	public String getStatusName() {
		return VersionStatus.fromCode(status);
	}

	@ApiModelProperty(value = "版本号")
	private Integer version;

	@ApiModelProperty(value = "全局参数，JSON对象格式字符串")
	private String taskParam;

	@ApiModelProperty(value = "流程编排SpEL表达式")
	private String taskSpel;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
