CREATE TABLE `sys_bpmn_task_define` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `task_code` varchar(64) NOT NULL COMMENT '任务编码',
    `task_name` varchar(64) DEFAULT NULL COMMENT '任务名称',
    `task_type` varchar(64) DEFAULT NULL COMMENT '任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程',
    `status` int DEFAULT '0' COMMENT '状态：0禁用；1启用；',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`),
    UNIQUE KEY `task_define_key` (`task_code`)
) ENGINE=InnoDB COMMENT='任务流程 - 定义表';

CREATE TABLE `sys_bpmn_task_version` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `mas_id` bigint NOT NULL COMMENT '主表ID',
    `task_code` varchar(64) NOT NULL COMMENT '任务编码',
    `status` int DEFAULT '1' COMMENT '发布状态：1未发布；2发布成功；3生效中；',
    `version` int DEFAULT '1' COMMENT '版本号',
    `task_param` text DEFAULT NULL COMMENT '全局参数，JSON对象格式字符串',
    `task_spel` mediumtext DEFAULT NULL COMMENT '流程编排SpEL表达式',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='任务流程 - 发布版本表';

CREATE TABLE `sys_bpmn_task_node` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `mas_id` bigint NOT NULL COMMENT '主表ID',
    `task_code` varchar(64) NOT NULL COMMENT '任务编码',
    `ver_id` bigint NOT NULL COMMENT '版本表ID',
    `version` int DEFAULT '1' COMMENT '版本号',
    `node_id` varchar(64) NOT NULL COMMENT '节点ID 随机生成',
    `node_name` varchar(64) DEFAULT NULL COMMENT '节点名称',
    `node_param` text DEFAULT NULL COMMENT '节点参数，JSON对象格式字符串',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='任务流程 - 节点表';

create table sys_bpmn_task_instance (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `mas_id` bigint NOT NULL COMMENT '主表ID',
    `task_code` varchar(64) NOT NULL COMMENT '任务编码',
    `ver_id` bigint NOT NULL COMMENT '版本表ID',
    `version` int DEFAULT '1' COMMENT '版本号',
    `instance_status` varchar(20) NULL COMMENT '日志行状态',
    `curr_node_id` varchar(64) NULL COMMENT '当前任务节点ID',
    `curr_node_name` varchar(64) NULL COMMENT '当前任务节点名称',
    `error_message` varchar(255) NULL COMMENT '错误日志',
    `start_time` datetime(6) NULL COMMENT '开始时间',
    `end_time` datetime(6) NULL COMMENT '结束时间',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`)
) comment='任务流程 - 实例表';

create table sys_bpmn_task_instance_step (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `instance_id` bigint NOT NULL COMMENT '实例ID',
    `node_id` varchar(64) NULL COMMENT '当前任务节点ID',
    `node_request` mediumtext DEFAULT NULL COMMENT '节点入参',
    `node_response` mediumtext DEFAULT NULL COMMENT '节点出参',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`)
) comment='任务流程 - 实例步骤回放表';