/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.config;

import com.elitesland.cbpl.bpmn.aspect.GlobalDefaultAspect;
import com.elitesland.cbpl.bpmn.config.BpmnProperties;
import com.elitesland.cbpl.bpmn.registrar.BpmnInitialize;
import com.elitesland.cbpl.bpmn.service.BpmnExecutor;
import com.elitesland.cbpl.bpmn.service.InstanceExecutor;
import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={BpmnProperties.class, LiteflowProperty.class})
@ConditionalOnProperty(prefix="liteflow", name={"enable"}, havingValue="true")
public class BpmnAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BpmnAutoConfiguration.class);

    @Bean
    public InstanceExecutor instanceExecutor() {
        return new InstanceExecutor();
    }

    @Bean
    @ConditionalOnBean
    public BpmnExecutor bpmnExecutor(FlowExecutor flowExecutor, InstanceExecutor instanceExecutor) {
        return new BpmnExecutor(flowExecutor, instanceExecutor);
    }

    @Bean
    public BpmnInitialize bpmnInitialize(BpmnExecutor bpmnExecutor) {
        BpmnInitialize bpmnInitialize = new BpmnInitialize(bpmnExecutor);
        logger.info("[PHOENIX-BPMN] Initialize finished.");
        return bpmnInitialize;
    }

    @Bean
    @ConditionalOnBean(value={FlowExecutor.class})
    @ConditionalOnMissingBean
    public ICmpAroundAspect globalDefaultAspect() {
        return new GlobalDefaultAspect();
    }
}

