package com.elitesland.cbpl.bpmn.config;

import com.elitesland.cbpl.bpmn.aspect.GlobalDefaultAspect;
import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.registrar.BpmnInitialize;
import com.elitesland.cbpl.bpmn.data.service.BpmnExecutor;
import com.elitesland.cbpl.bpmn.data.service.InstanceExecutor;
import com.elitesland.cbpl.bpmn.task.BpmnInstanceDeletionTask;
import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2024/03/05
 */
@Slf4j
@Configuration
@EnableConfigurationProperties({BpmnProperties.class, LiteflowProperty.class})
@ConditionalOnProperty(prefix = "liteflow", name = "enable", havingValue = "true")
@RequiredArgsConstructor
public class BpmnAutoConfiguration {

    /**
     * 实例日志调度
     */
    @Bean
    public InstanceExecutor instanceExecutor() {
        return new InstanceExecutor();
    }

    /**
     * 流程调度
     */
    @Bean
    @ConditionalOnClass
    public BpmnExecutor bpmnExecutor(FlowExecutor flowExecutor, InstanceExecutor instanceExecutor) {
        return new BpmnExecutor(flowExecutor, instanceExecutor);
    }

    /**
     * 流程初始化注册
     */
    @Bean
    public BpmnInitialize bpmnInitialize(BpmnExecutor bpmnExecutor) {
        BpmnInitialize bpmnInitialize = new BpmnInitialize(bpmnExecutor);
        logger.info("[PHOENIX-BPMN] Initialize finished.");
        return bpmnInitialize;
    }

    /**
     * 全局组件拦截器
     */
    @Bean
    @ConditionalOnMissingBean
    public ICmpAroundAspect globalDefaultAspect() {
        return new GlobalDefaultAspect();
    }

    /**
     * 实例定时删除任务
     */
    @Bean
    @ConditionalOnClass
    public BpmnInstanceDeletionTask bpmnInstanceDeletionTask(TaskDefineService defineService, TaskInstanceService instanceService) {
        return new BpmnInstanceDeletionTask(defineService, instanceService);
    }
}
