package com.elitesland.cbpl.bpmn.controller;

import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
@Slf4j
@Api(tags = "任务流程 - 实例表")
@RestController
@RequestMapping("/bpmn/instance")
@RequiredArgsConstructor
public class TaskInstanceController {

    private final TaskInstanceService taskInstanceService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/list")
    public HttpResult<PagingVO<TaskInstancePagingVO>> list(@RequestBody TaskInstancePagingParamVO query) {
        logger.info("[TaskInstance] query paging param = {}", query);
        return HttpResult.ok(taskInstanceService.taskInstancePageBy(query));
    }
}
