package com.elitesland.cbpl.bpmn.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.data.entity.QTaskDefineDO;
import com.elitesland.cbpl.bpmn.data.entity.QTaskVersionDO;
import com.elitesland.cbpl.bpmn.domain.TaskStatus;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefinePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefinePagingVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
@Component
@RequiredArgsConstructor
public class TaskDefineRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QTaskDefineDO taskDefineDO = QTaskDefineDO.taskDefineDO;
    private static final QTaskVersionDO taskVersionDO = QTaskVersionDO.taskVersionDO;

    private final QBean<TaskDefinePagingVO> taskDefinePagingVO = Projections.bean(
            TaskDefinePagingVO.class,
            taskDefineDO.id,
            taskDefineDO.taskCode,
            taskDefineDO.taskName,
            taskDefineDO.taskType,
            taskDefineDO.status,
            taskDefineDO.deletionStrategy,
            taskDefineDO.remark,
            taskDefineDO.createUserId,
            taskDefineDO.creator,
            taskDefineDO.createTime,
            taskDefineDO.modifyUserId,
            taskDefineDO.updater,
            taskDefineDO.modifyTime
    );

    private Predicate pagingWhere(TaskDefinePagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(taskDefineDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(taskDefineDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(taskDefineDO.taskCode.eq(query.getTaskCode()));
        }
        if (StrUtil.isNotBlank(query.getTaskName())) {
            predicates.add(taskDefineDO.taskName.eq(query.getTaskName()));
        }
        if (StrUtil.isNotBlank(query.getTaskType())) {
            predicates.add(taskDefineDO.taskType.eq(query.getTaskType()));
        }
        if (ObjectUtil.isNotNull(query.getStatus())) {
            predicates.add(taskDefineDO.status.eq(query.getStatus()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(taskDefineDO.remark.eq(query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long taskDefineCountBy(TaskDefinePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(taskDefineDO.id)
                .from(taskDefineDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TaskDefinePagingVO> taskDefinePageBy(TaskDefinePagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(taskDefinePagingVO)
                .from(taskDefineDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, taskDefineDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<TaskDefineRespVO> taskDefineVO = Projections.bean(
            TaskDefineRespVO.class,
            taskDefineDO.id,
            taskDefineDO.taskCode,
            taskDefineDO.taskName,
            taskDefineDO.taskType,
            taskDefineDO.status,
            taskDefineDO.deletionStrategy,
            taskVersionDO.version,
            taskVersionDO.taskParam,
            taskVersionDO.taskSpel
    );

    private Predicate where(TaskDefineQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(taskDefineDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(taskDefineDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(taskDefineDO.taskCode.eq(query.getTaskCode()));
        }
        if (StrUtil.isNotBlank(query.getTaskName())) {
            predicates.add(taskDefineDO.taskName.eq(query.getTaskName()));
        }
        if (StrUtil.isNotBlank(query.getTaskType())) {
            predicates.add(taskDefineDO.taskType.eq(query.getTaskType()));
        }
        if (ObjectUtil.isNotNull(query.getStatus())) {
            predicates.add(taskDefineDO.status.eq(query.getStatus()));
        }
        if (ObjectUtil.isNotNull(query.getVersion())) {
            predicates.add(taskVersionDO.version.eq(query.getVersion()));
        }
        if (ObjectUtil.isNotNull(query.getVersionStatus())) {
            predicates.add(taskVersionDO.status.eq(query.getVersionStatus()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<TaskDefineRespVO> taskDefineByParam(TaskDefineQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(taskDefineVO)
                .from(taskDefineDO)
                .leftJoin(taskVersionDO).on(taskVersionDO.masId.eq(taskDefineDO.id));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long updateStatus(Long id, Integer status) {
        JPAUpdateClause update = jpaQueryFactory.update(taskDefineDO)
                .set(taskDefineDO.status, status)
                .where(taskDefineDO.id.eq(id));
        return update.execute();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(taskDefineDO)
                .set(taskDefineDO.deleteFlag, 1)
                .where(taskDefineDO.id.in(ids).and(taskDefineDO.status.eq(TaskStatus.INACTIVE.getCode())));
        return update.execute();
    }
}
