package com.elitesland.cbpl.bpmn.data.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.bpmn.data.service.TaskClientService;
import com.elitesland.cbpl.bpmn.data.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.data.service.BpmnExecutor;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.yomahub.liteflow.flow.LiteflowResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2024/05/10
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class TaskClientServiceImpl implements TaskClientService {

    private final TaskVersionService taskVersionService;
    @Autowired(required = false)
    private BpmnExecutor bpmnExecutor;

    @Override
    public HttpResult<?> execute(String taskCode, Object paramObj) {
        int version = taskVersionService.queryEffectiveVersion(taskCode);
        return execute(taskCode, version, paramObj);
    }

    @Override
    public HttpResult<?> execute(String taskCode, Integer version, Object paramObj) {
        if (ObjectUtil.isNull(bpmnExecutor)) {
            logger.warn("[PHOENIX-BPMN] BpmnExecutor Unregistered.");
            return HttpResult.notImplemented("BpmnExecutor Unregistered.");
        }
        LiteflowResponse response = bpmnExecutor.start(taskCode, version, paramObj);
        if (response.isSuccess()) {
            StandardContext<?> context = response.getContextBean(StandardContext.class);
            return HttpResult.ok(context.getHttpResult());
        }
        return HttpResult.error(response.getCode(), response.getMessage());
    }
}
