package com.elitesland.cbpl.bpmn.data.vo.param;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务流程 - 实例表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 实例表")
public class TaskInstancePagingParamVO extends PageQueryParam {

	private static final long serialVersionUID = -6585036519766930819L;

	@ApiModelProperty(value = "任务编码")
	private String taskCode;

	@ApiModelProperty(value = "版本号")
	private Integer version;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "当前任务节点ID")
	private String currNodeId;

	@ApiModelProperty(value = "当前任务节点名称")
	private String currNodeName;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "备注")
	private String remark;
}
