package com.elitesland.cbpl.bpmn.data.vo.resp;

import com.elitesland.cbpl.scheduling.domain.InstanceStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务流程 - 实例表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 实例表")
public class TaskInstancePagingVO implements Serializable {

	private static final long serialVersionUID = 4819212051280915212L;

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "任务名称")
	private String taskName;

	@ApiModelProperty(value = "任务编码")
	private String taskCode;

	@ApiModelProperty(value = "版本号")
	private Integer version;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@JsonProperty
	public String getInstanceStatusName() {
		return InstanceStatus.fromCode(instanceStatus);
	}

	@ApiModelProperty(value = "当前任务节点ID")
	private String currNodeId;

	@ApiModelProperty(value = "当前任务节点名称")
	private String currNodeName;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "开始时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "备注")
	private String remark;
}
