package com.elitesland.cbpl.bpmn.domain;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Getter
public enum TaskStatus {

    /**
     * 表单状态
     */
    ACTIVE(1, "启用"),
    INACTIVE(0, "禁用"),
    ;

    private final Integer code;
    private final String desc;

    TaskStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        for (TaskStatus status : TaskStatus.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
