package com.elitesland.cbpl.bpmn.task;

import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceDeleteParamVO;
import com.elitesland.cbpl.bpmn.domain.VersionStatus;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import static com.elitesland.cbpl.bpmn.config.BpmnProperties.BPMN_DELETION_CRON;
import static com.elitesland.cbpl.bpmn.config.BpmnProperties.BPMN_ENABLED;
import static com.elitesland.cbpl.scheduling.domain.InstanceStatus.*;

/**
 * @author eric.hao
 * @since 2024/05/11
 */
@Slf4j
@RequiredArgsConstructor
@UnicomTag("__BpmnInstanceDeletionTask")
public class BpmnInstanceDeletionTask implements SchedulingRegistrarSpi {

    private final TaskDefineService defineService;
    private final TaskInstanceService instanceService;

    @Override
    public boolean autoRegister() {
        return BPMN_ENABLED;
    }

    /**
     * 构建定时任务
     */
    @Override
    public ScheduledTask registerTask() {
        return SchedulingUtil.registerTask(this.getClass(), "流程编排实例-定时删除").build()
                .setTrigger(this.getClass().getName(), "deletion", BPMN_DELETION_CRON);
    }

    public void deletion() {
        // 所有未删除的任务
        TaskDefineQueryParamVO query = new TaskDefineQueryParamVO();
        query.setVersionStatus(VersionStatus.EFFECTIVE.getCode());
        var tasks = defineService.taskDefineByParam(query);
        for (var task : tasks) {
            if (task.noDeletion()) {
                logger.warn("[PHOENIX-BPMN] {} deletion strategy: {}", task.getTaskCode(), task.getDeletionStrategyName());
                continue;
            }
            var deleteParam = new TaskInstanceDeleteParamVO();
            deleteParam.setTaskCode(task.getTaskCode());
            // 完成、异常中断、手动终止
            deleteParam.setInstanceStatus(List.of(COMPLETE.getCode(), INTERRUPT.getCode(), STOP.getCode()));
            deleteParam.setBeforeTime(SchedulingUtil.minusDays(task.getDeletionStrategy()));
            instanceService.deleteInstance(deleteParam, "AUTO");
        }
    }
}
