/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.data.service.BpmnExecutor;
import com.elitesland.cbpl.bpmn.data.service.TaskClientService;
import com.elitesland.cbpl.bpmn.data.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.yomahub.liteflow.flow.LiteflowResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskClientServiceImpl
implements TaskClientService {
    private static final Logger logger = LoggerFactory.getLogger(TaskClientServiceImpl.class);
    private final TaskVersionService taskVersionService;
    @Autowired(required=false)
    private BpmnExecutor bpmnExecutor;

    @Override
    public HttpResult<?> execute(String taskCode, Object paramObj) {
        int version = this.taskVersionService.queryEffectiveVersion(taskCode);
        return this.execute(taskCode, version, paramObj);
    }

    @Override
    public HttpResult<?> execute(String taskCode, Integer version, Object paramObj) {
        if (ObjectUtil.isNull((Object)this.bpmnExecutor)) {
            logger.warn("[PHOENIX-BPMN] BpmnExecutor Unregistered.");
            return HttpResult.notImplemented((String)"BpmnExecutor Unregistered.");
        }
        LiteflowResponse response = this.bpmnExecutor.start(taskCode, version, paramObj);
        if (response.isSuccess()) {
            StandardContext context = (StandardContext)response.getContextBean(StandardContext.class);
            return HttpResult.ok(context.getHttpResult());
        }
        return HttpResult.error((String)response.getCode(), (String)response.getMessage());
    }

    public TaskClientServiceImpl(TaskVersionService taskVersionService) {
        this.taskVersionService = taskVersionService;
    }
}

