/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.domain.context;

import cn.hutool.core.util.ObjectUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalContext {
    private static final Logger logger = LoggerFactory.getLogger(GlobalContext.class);
    private Map<String, String> globalParams = new HashMap<String, String>();
    private Map<String, Map<String, String>> nodeParams = new HashMap<String, Map<String, String>>();

    public String getGlobalParam(String key) {
        return this.globalParams.get(key);
    }

    public void addGlobalParam(String key, String value) {
        this.globalParams.put(key, value);
    }

    public String getNodeParam(String nodeId, String key) {
        Map<String, String> nodeParam = this.nodeParams.get(nodeId);
        if (ObjectUtil.isNull(nodeParam)) {
            logger.trace("[PHOENIX-BPMN] Invalid Node - {}", (Object)nodeId);
            return null;
        }
        return nodeParam.get(key);
    }

    public void addNodeParam(String nodeId, String key, String value) {
        Map<String, String> nodeParam = this.nodeParams.get(nodeId);
        if (ObjectUtil.isNull(nodeParam)) {
            nodeParam = new HashMap<String, String>();
        }
        nodeParam.put(key, value);
        this.nodeParams.put(nodeId, nodeParam);
    }

    public Map<String, String> getGlobalParams() {
        return this.globalParams;
    }

    public Map<String, Map<String, String>> getNodeParams() {
        return this.nodeParams;
    }

    public void setGlobalParams(Map<String, String> globalParams) {
        this.globalParams = globalParams;
    }

    public void setNodeParams(Map<String, Map<String, String>> nodeParams) {
        this.nodeParams = nodeParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalContext)) {
            return false;
        }
        GlobalContext other = (GlobalContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$globalParams = this.getGlobalParams();
        Map<String, String> other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !((Object)this$globalParams).equals(other$globalParams)) {
            return false;
        }
        Map<String, Map<String, String>> this$nodeParams = this.getNodeParams();
        Map<String, Map<String, String>> other$nodeParams = other.getNodeParams();
        return !(this$nodeParams == null ? other$nodeParams != null : !((Object)this$nodeParams).equals(other$nodeParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : ((Object)$globalParams).hashCode());
        Map<String, Map<String, String>> $nodeParams = this.getNodeParams();
        result = result * 59 + ($nodeParams == null ? 43 : ((Object)$nodeParams).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalContext(globalParams=" + this.getGlobalParams() + ", nodeParams=" + this.getNodeParams() + ")";
    }
}

