/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.registrar;

import com.elitesland.cbpl.bpmn.data.service.BpmnExecutor;
import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.bpmn.domain.TaskStatus;
import com.elitesland.cbpl.bpmn.domain.VersionStatus;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class BpmnInitialize
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BpmnInitialize.class);
    @Resource
    private TaskDefineService taskDefineService;
    private final BpmnExecutor bpmnExecutor;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                TaskDefineQueryParamVO query = new TaskDefineQueryParamVO();
                query.setStatus(TaskStatus.ACTIVE.getCode());
                query.setVersionStatus(VersionStatus.EFFECTIVE.getCode());
                TenantSpiUtil.byTenants(() -> {
                    List<TaskDefineRespVO> taskDefine = this.taskDefineService.taskDefineByParam(query);
                    taskDefine.forEach(task -> this.bpmnExecutor.register(task.getTaskCode(), task.getVersion(), task.getTaskSpel()));
                });
            }
            catch (Exception e) {
                logger.error("[PHOENIX-BPMN] initialize failed: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            }
        }).start();
    }

    public BpmnInitialize(BpmnExecutor bpmnExecutor) {
        this.bpmnExecutor = bpmnExecutor;
    }
}

