package com.elitesland.cbpl.bpmn.domain.context;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * Infinity接口调度的模板上下文
 *
 * @author eric.hao
 * @since 2024/05/08
 */
@Slf4j
@Data
public class InfinityContext {

    /**
     * 接口数据
     * <li>key:节点名称，value:接口编码</li>
     */
    private Map<String, String> routers = new HashMap<>();

    /**
     * 获取接口编码
     *
     * @param nodeId 节点唯一标识
     * @return 接口编码
     */
    public String getTemplateCode(String nodeId) {
        return routers.get(nodeId);
    }

    /**
     * 添加接口参数
     *
     * @param nodeId       节点唯一标识
     * @param templateCode 接口编码
     */
    public void addTemplateCode(String nodeId, String templateCode) {
        routers.put(nodeId, templateCode);
    }
}
