package com.elitesland.cbpl.bpmn.registrar.task;

import com.elitesland.cbpl.bpmn.data.service.TaskClientService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 提供schedule调度工具，对流程指定流程调用执行
 *
 * @author eric.hao
 * @since 2024/05/27
 */
@Slf4j
@RequiredArgsConstructor
public class BpmnCronTask {

    private final TaskClientService clientService;

    public void invoke(String taskCode) {
        HttpResult<?> result = clientService.execute(taskCode);
        logger.info("[PHOENIX-BPMN] schedule invoke: {}, result: {}", taskCode, result);
    }
}
