package com.elitesland.cbpl.bpmn.util;

import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.yomahub.liteflow.flow.LiteflowResponse;

/**
 * @author eric.hao
 * @since 2024/05/10
 */
public class BpmnUtil {

    /**
     * 流程主键：任务编码_版本号
     */
    public static String chainKey(String taskCode, Integer version) {
        return chainKey(taskCode + StrPool.C_UNDERLINE + version);
    }

    /**
     * 流程主键，按租户区分
     */
    public static String chainKey(String chainKey) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        return StrUtil.isBlank(tenantCode) ? chainKey : tenantCode + StrPool.C_UNDERLINE + chainKey;
    }

    public static LiteflowResponse errorResponse() {
        LiteflowResponse response = new LiteflowResponse();
        response.setSuccess(false);
        response.setCode("");
        response.setMessage("");
        return response;
    }
}
