/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.config;

import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="cbpl.bpmn")
public class BpmnProperties
implements InitializingBean,
EnvironmentAware {
    private Environment environment;
    public static final String BPMN_CONFIG_PREFIX = "cbpl.bpmn";
    private String deletionStrategyCron = "0 10 1 * * ?";
    public static boolean BPMN_ENABLED;
    public static String BPMN_DELETION_CRON;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        String property = this.environment.getProperty("liteflow.enable");
        if (StrUtil.isBlank((CharSequence)property)) {
            property = "false";
        }
        BPMN_ENABLED = Boolean.parseBoolean(property);
        BPMN_DELETION_CRON = this.deletionStrategyCron;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getDeletionStrategyCron() {
        return this.deletionStrategyCron;
    }

    public void setDeletionStrategyCron(String deletionStrategyCron) {
        this.deletionStrategyCron = deletionStrategyCron;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BpmnProperties)) {
            return false;
        }
        BpmnProperties other = (BpmnProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$deletionStrategyCron = this.getDeletionStrategyCron();
        String other$deletionStrategyCron = other.getDeletionStrategyCron();
        return !(this$deletionStrategyCron == null ? other$deletionStrategyCron != null : !this$deletionStrategyCron.equals(other$deletionStrategyCron));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BpmnProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $deletionStrategyCron = this.getDeletionStrategyCron();
        result = result * 59 + ($deletionStrategyCron == null ? 43 : $deletionStrategyCron.hashCode());
        return result;
    }

    public String toString() {
        return "BpmnProperties(environment=" + this.getEnvironment() + ", deletionStrategyCron=" + this.getDeletionStrategyCron() + ")";
    }
}

