/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.registrar;

import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.bpmn.spi.BpmnInitializeSpi;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.common.constant.PublishStatus;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class BpmnInitialize
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BpmnInitialize.class);
    @Resource
    private TaskDefineService taskDefineService;
    private final BpmnExecutor bpmnExecutor;
    @Autowired(required=false)
    private BpmnInitializeSpi bpmnInitializeSpi;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                while (this.bpmnInitializeSpi != null && !this.bpmnInitializeSpi.initializeCompleted()) {
                    Thread.sleep(100L);
                }
                TaskDefineQueryParamVO query = new TaskDefineQueryParamVO();
                query.setStatus(ActiveStatus.ACTIVE.getCode());
                query.setVersionStatus(PublishStatus.EFFECTIVE.getCode());
                TenantSpiUtil.byTenants(() -> {
                    List<TaskDefineRespVO> taskDefine = this.taskDefineService.taskDefineByParam(query);
                    taskDefine.forEach(task -> this.bpmnExecutor.register(task.getTaskCode(), task.getVersion(), task.getTaskSpel()));
                });
            }
            catch (Exception e) {
                logger.error("[PHOENIX-BPMN] initialize failed: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            }
        }).start();
    }

    public BpmnInitialize(BpmnExecutor bpmnExecutor) {
        this.bpmnExecutor = bpmnExecutor;
    }
}

