package com.elitesland.cbpl.bpmn.data.controller;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.bpmn.data.service.TaskClientService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2024/05/10
 */
@Slf4j
@Api(tags = "任务流程 - 客户端调度接口")
@RestController
@RequestMapping("/bpmn/client")
@RequiredArgsConstructor
public class TaskClientController {

    private final TaskClientService taskClientService;
    @Autowired(required = false)
    private BpmnExecutor bpmnExecutor;

    @ApiOperation(value = "立即执行一次")
    @PostMapping(value = "/task/{taskCode}")
    public HttpResult<?> execute(@PathVariable("taskCode") String taskCode, @RequestBody Object paramObj) {
        logger.info("[PHOENIX-BPMN] execute taskCode: {}, params: {}", taskCode, paramObj);
        return taskClientService.execute(taskCode, paramObj);
    }

    @ApiOperation(value = "立即执行一次，指定版本")
    @PostMapping(value = "/task/{taskCode}/{version}")
    public HttpResult<?> executeVersion(
            @PathVariable("taskCode") String taskCode, @PathVariable("version") Integer version, @RequestBody Object paramObj) {
        logger.info("[PHOENIX-BPMN] execute taskCode: {}, version: {},  params: {}", taskCode, version, paramObj);
        return taskClientService.execute(taskCode, version, paramObj);
    }

    @ApiOperation(value = "所有已注册的流程")
    @GetMapping(value = "/task/register/all")
    public HttpResult<?> queryTaskDefineAll() {
        if (ObjectUtil.isNull(bpmnExecutor)) {
            logger.warn("[PHOENIX-BPMN] BpmnExecutor Unregistered.");
            return HttpResult.notImplemented("BpmnExecutor Unregistered.");
        }
        return HttpResult.ok(bpmnExecutor.chainAll());
    }
}
