package com.elitesland.cbpl.bpmn.data.service;

import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceDeleteParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstanceDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
public interface TaskInstanceService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    TaskInstanceDetailVO taskInstanceById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(TaskInstanceSaveParamVO saveParam);

    /**
     * 更新执行结果
     *
     * @param saveParam 更新参数
     */
    void update(TaskInstanceSaveParamVO saveParam);

    /**
     * 删除实例日志
     *
     * @param paramVO 删除参数
     * @param source  调用方式：AUTO定时任务执行；INVOKE手动调用；
     * @return 删除行数
     */
    long deleteInstance(TaskInstanceDeleteParamVO paramVO, String source);

    /**
     * 日志删除策略-CRON表达式预览
     */
    List<String> strategyPreview();
}
