package com.elitesland.cbpl.bpmn.data.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionPagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionPagingVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
public interface TaskVersionService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<TaskVersionPagingVO> taskVersionPageBy(TaskVersionPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<TaskVersionRespVO> taskVersionByParam(TaskVersionQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    TaskVersionDetailVO taskVersionById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(TaskVersionSaveParamVO saveParam);

    /**
     * 发布生效
     *
     * @param id 业务单据ID
     */
    long published(Long id);

    /**
     * 物理删除
     *
     * @param id 业务单据ID
     * @return 删除成功的数量
     */
    long delete(Long id);

    /**
     * 查询当前最大版本号，无数据返回0
     *
     * @param taskCode 任务编码
     * @return 版本号
     */
    int queryMaxVersion(String taskCode);

    /**
     * 查询生效中的版本
     *
     * @param taskCode 任务编码
     * @return 版本号
     */
    int queryEffectiveVersion(String taskCode);
}
