package com.elitesland.cbpl.bpmn.data.vo.param;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 任务流程 - 定义表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 定义表")
public class TaskDefineSaveParamVO {

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "任务编码")
	@NotBlank(message = "任务编码必填")
	private String taskCode;

	@ApiModelProperty(value = "任务名称")
	@NotBlank(message = "任务名称必填")
	private String taskName;

	@ApiModelProperty(value = "任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程")
	@NotBlank(message = "任务类型必填")
	private String taskType;

	@ApiModelProperty(value = "实例删除策略")
	private String deletionStrategy;

	@ApiModelProperty(value = "备注")
	private String remark;

	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
