package com.elitesland.cbpl.bpmn.domain.component;

import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import lombok.extern.slf4j.Slf4j;

/**
 * 终止节点
 *
 * @author eric.hao
 * @since 2024/05/07
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_END)
public class EndComponent extends NodeComponent {

    @Override
    public void process() throws Exception {
        // 上下文参数
        var standardContext = this.getContextBean(StandardContext.class);
        // 输出结果
        standardContext.setHttpResult();
        LogUtil.info("[BPMN] process end.");
    }

    /**
     * 后置处理器
     */
    @Override
    public void afterProcess() {
        // todo 后置逻辑，设置节点出参等
    }
}
