package com.elitesland.cbpl.bpmn.registrar;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.common.constant.PublishStatus;
import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/08
 */
@Slf4j
@RequiredArgsConstructor
public class BpmnInitialize implements InitializingBean {

    @Resource
    private TaskDefineService taskDefineService;
    private final BpmnExecutor bpmnExecutor;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                TaskDefineQueryParamVO query = new TaskDefineQueryParamVO();
                query.setStatus(ActiveStatus.ACTIVE.getCode());
                query.setVersionStatus(PublishStatus.EFFECTIVE.getCode());

                TenantSpiUtil.byTenants(() -> {
                    List<TaskDefineRespVO> taskDefine = taskDefineService.taskDefineByParam(query);
                    taskDefine.forEach(task -> bpmnExecutor.register(task.getTaskCode(), task.getVersion(), task.getTaskSpel()));
                });
            } catch (Exception e) {
                logger.error("[PHOENIX-BPMN] initialize failed: {}", ExceptionUtils.formatException(e));
            }
        }).start();
    }
}
