package com.elitesland.cbpl.bpmn.util;

import cn.hutool.core.text.StrPool;
import com.elitesland.cbpl.bpmn.constant.BpmnScheduleTag;
import com.elitesland.cbpl.bpmn.registrar.task.BpmnCronTask;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.scheduling.constant.DeletionStrategy;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;

/**
 * @author eric.hao
 * @since 2024/05/27
 */
public class BpmnParamUtil {

    private static final String METHOD_BPMN_TASK_INVOKE_KEY = "invoke";

    /**
     * 流程编排 - 默认参数
     */
    public static ScheduleConfigSaveParamVO bpmnParamInit(String taskCode, String taskName, String cron) {
        Class<?> clazz = BpmnCronTask.class;
        var saveParam = new ScheduleConfigSaveParamVO();
        saveParam.setTaskCode(taskKey(taskCode));
        saveParam.setTaskName(taskName);
        saveParam.setClassName(clazz.getName());
        saveParam.setMethod(METHOD_BPMN_TASK_INVOKE_KEY);
        saveParam.setCustomArgs(taskCode);
        saveParam.setCron(cron);
        saveParam.setStatus(ActiveStatus.ACTIVE.getCode());
        saveParam.setDeletionStrategy(DeletionStrategy.NO_DELETION.getDays());
        saveParam.setTags(BpmnScheduleTag.SCHEDULE_BPMN_TASK_TAG);
        return saveParam;
    }

    /**
     * 注册定时任务的主键Key
     */
    public static String taskKey(String taskCode) {
        return BpmnScheduleTag.SCHEDULE_BPMN_TASK_TAG + StrPool.C_UNDERLINE + BpmnUtil.chainKey(taskCode);
    }
}
