/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.registrar.execute;

import com.elitesland.cbpl.bpmn.data.convert.TaskInstanceConvert;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstanceRespVO;
import com.elitesland.cbpl.bpmn.spi.BpmnCompleteSpi;
import com.elitesland.cbpl.bpmn.util.BpmnUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.scheduling.constant.InstanceStatus;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import com.yomahub.liteflow.flow.LiteflowResponse;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(InstanceExecutor.class);
    @Resource
    private TaskInstanceService taskInstanceService;
    @Autowired(required=false)
    private BpmnCompleteSpi bpmnCompleteSpi;

    public TaskInstanceSaveParamVO instanceLog(String taskCode, Integer version, String runType) {
        try {
            TaskInstanceSaveParamVO saveParam = new TaskInstanceSaveParamVO();
            saveParam.setTaskCode(taskCode);
            saveParam.setVersion(version);
            saveParam.setStartTime(LocalDateTime.now());
            saveParam.setInstanceStatus(InstanceStatus.RUNNING.getCode());
            saveParam.setRemark(runType);
            Long instanceId = this.taskInstanceService.save(saveParam);
            saveParam.setId(instanceId);
            return saveParam;
        }
        catch (Exception e) {
            logger.error("[PHOENIX-BPMN] insert instanceLog error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            TaskInstanceSaveParamVO saveParam = new TaskInstanceSaveParamVO();
            saveParam.setId(0L);
            return saveParam;
        }
    }

    public LiteflowResponse record(TaskInstanceSaveParamVO instance, Supplier<LiteflowResponse> supplier) {
        LiteflowResponse result = BpmnUtil.errorResponse();
        try {
            if (this.bpmnCompleteSpi != null) {
                TaskInstanceRespVO response = TaskInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.bpmnCompleteSpi.start(response);
            }
        }
        catch (Exception e) {
            logger.error("[PHOENIX-BPMN] execute complete start error.", (Throwable)e);
        }
        Exception throwable = null;
        try {
            result = supplier.get();
            if (result.isSuccess()) {
                instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
            } else {
                instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
                instance.setErrorMessage(StringUtils.exceed((CharSequence)result.getMessage(), (int)255));
                LogUtil.error((String)("[BPMN] process interrupt: " + StringUtils.exceed((CharSequence)result.getMessage(), (int)255)));
            }
            instance.setRemark(instance.getRemark() + "\uff1b\u6267\u884c\u6b65\u9aa4\uff1a" + result.getExecuteStepStr());
            LogUtil.info((String)("[BPMN] process \u6267\u884c\u6b65\u9aa4: " + result.getExecuteStepStr()));
        }
        catch (Exception e) {
            throwable = e;
            instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
            instance.setErrorMessage(ExceptionUtils.formatException((Throwable)e, (int)255));
            logger.error("[PHOENIX-BPMN] execute error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            LogUtil.error((String)"[BPMN] execute error.", (Throwable)e);
        }
        try {
            instance.setEndTime(LocalDateTime.now());
            this.taskInstanceService.update(instance);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-BPMN] update instanceLog error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            LogUtil.error((String)"[BPMN] update instanceLog error.", (Throwable)e);
        }
        try {
            if (this.bpmnCompleteSpi != null) {
                TaskInstanceRespVO response = TaskInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.bpmnCompleteSpi.whenComplete(response, throwable);
            }
        }
        catch (Exception e) {
            logger.error("[PHOENIX-BPMN] execute complete callback error.", (Throwable)e);
        }
        return result;
    }
}

