package com.elitesland.cbpl.bpmn.data.convert;

import com.elitesland.cbpl.bpmn.data.entity.TaskVersionDO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionDetailVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Mapper(config = BaseMapperConfig.class)
public interface TaskVersionConvert {

	TaskVersionConvert INSTANCE = Mappers.getMapper(TaskVersionConvert.class);

    /**
     * DO => RespVO
     */
    TaskVersionDetailVO doToVO(TaskVersionDO taskVersionDO);

    /**
     * SaveParam => DO
     */
    TaskVersionDO saveParamToDO(TaskVersionSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(TaskVersionSaveParamVO saveParam, @MappingTarget TaskVersionDO taskVersionDO);
}
