package com.elitesland.cbpl.bpmn.data.vo.param;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 任务流程 - 发布版本表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 发布版本表")
public class TaskVersionSaveParamVO {

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "主表ID")
	@NotNull(message = "任务ID必填")
	private Long masId;

	@ApiModelProperty(value = "任务编码")
	@NotBlank(message = "任务编码必填")
	private String taskCode;

	@ApiModelProperty(value = "全局参数，JSON对象格式字符串")
	private String taskParam;

	@ApiModelProperty(value = "流程编排SpEL表达式")
	@NotBlank(message = "编排表达式必填")
	private String taskSpel;

	@ApiModelProperty(value = "备注")
	private String remark;

	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
