/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.controller;

import com.elitesland.cbpl.bpmn.data.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionPagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionPagingVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u6d41\u7a0b - \u53d1\u5e03\u7248\u672c\u8868"})
@RestController
@RequestMapping(value={"/bpmn/version"})
public class TaskVersionController {
    private static final Logger logger = LoggerFactory.getLogger(TaskVersionController.class);
    private final TaskVersionService taskVersionService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<TaskVersionPagingVO>> list(@RequestBody @Valid TaskVersionPagingParamVO query) {
        logger.info("[TaskVersion] query paging param = {}", (Object)query);
        return HttpResult.ok(this.taskVersionService.taskVersionPageBy(query));
    }

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public HttpResult<List<TaskVersionRespVO>> query(@RequestBody @Valid TaskVersionQueryParamVO query) {
        logger.info("[TaskVersion] query list param = {}", (Object)query);
        return HttpResult.ok(this.taskVersionService.taskVersionByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<TaskVersionDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[TaskVersion] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskVersionService.taskVersionById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody @Valid TaskVersionSaveParamVO saveParam) {
        logger.info("[TaskVersion] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.taskVersionService.save(saveParam));
    }

    @ApiOperation(value="\u53d1\u5e03\u751f\u6548")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> published(@PathVariable(value="id") Long id) {
        logger.info("[TaskVersion] active by id = {}", (Object)id);
        this.taskVersionService.published(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/{id}/delete"})
    public HttpResult<Long> delete(@PathVariable(value="id") Long id) {
        logger.info("[TaskVersion] physical delete by id = {}", (Object)id);
        return HttpResult.ok((Object)this.taskVersionService.delete(id));
    }

    public TaskVersionController(TaskVersionService taskVersionService) {
        this.taskVersionService = taskVersionService;
    }
}

