/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.registrar.execute;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.config.BpmnProperties;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.registrar.execute.InstanceExecutor;
import com.elitesland.cbpl.bpmn.spi.BpmnContextSpi;
import com.elitesland.cbpl.bpmn.util.BpmnUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.LiteflowResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BpmnExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BpmnExecutor.class);
    private final FlowExecutor flowExecutor;
    private final InstanceExecutor instanceExecutor;
    @Autowired(required=false)
    private BpmnContextSpi bpmnContextSpi;

    private FlowExecutor getInstance() {
        if (!BpmnProperties.BPMN_ENABLED) {
            throw PhoenixException.unexpected((String)"bpmn executor not enabled.");
        }
        return this.flowExecutor;
    }

    public void register(String taskCode, Integer version, String flowSpEL) {
        LiteFlowChainELBuilder.createChain().setChainId(BpmnUtil.chainKey(taskCode, version)).setEL(flowSpEL).build();
    }

    public void destroy(String taskCode, Integer version) {
        if (this.containChain(taskCode, version)) {
            FlowBus.removeChain((String)BpmnUtil.chainKey(taskCode, version));
        }
    }

    public void refresh(String taskCode, Integer version, String flowSpEL) {
        this.destroy(taskCode, version);
        this.register(taskCode, version, flowSpEL);
    }

    public LiteflowResponse start(String taskCode, Integer version) {
        return this.start(taskCode, version, null);
    }

    public LiteflowResponse start(String taskCode, Integer version, Object param) {
        List<Class<?>> extra;
        List<Class<?>> context = BpmnConstant.bpmnCommonContext();
        if (ObjectUtil.isNotNull((Object)this.bpmnContextSpi) && CollUtil.isNotEmpty(extra = this.bpmnContextSpi.extraContext())) {
            context.addAll(extra);
        }
        return this.start(taskCode, version, param, context.toArray(new Class[0]));
    }

    public LiteflowResponse start(String taskCode, Integer version, Object param, Class<?> ... contextBeanClazzArray) {
        TaskInstanceSaveParamVO instance = this.instanceExecutor.instanceLog(taskCode, version, "\u624b\u52a8\u6267\u884c");
        return this.instanceExecutor.record(instance, () -> this.getInstance().execute2Resp(BpmnUtil.chainKey(taskCode, version), param, contextBeanClazzArray));
    }

    public boolean containChain(String taskCode, Integer version) {
        return FlowBus.containChain((String)BpmnUtil.chainKey(taskCode, version));
    }

    public Set<String> chainAll() {
        Map chainMap = FlowBus.getChainMap();
        return chainMap.keySet();
    }

    public BpmnExecutor(FlowExecutor flowExecutor, InstanceExecutor instanceExecutor) {
        this.flowExecutor = flowExecutor;
        this.instanceExecutor = instanceExecutor;
    }
}

