package com.elitesland.cbpl.bpmn.domain.component;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import lombok.extern.slf4j.Slf4j;

/**
 * 起始节点
 *
 * @author eric.hao
 * @since 2024/05/07
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_START)
public class StartComponent extends NodeComponent {

    /**
     * 前置处理器
     */
    @SuppressWarnings("unchecked")
    @Override
    public void beforeProcess() {
        // 流程入参
        var nodeParam = this.getCmpData(Object.class);
        // 并作为`StandardContext`的出参
        if (ObjectUtil.isNotNull(nodeParam)) {
            var standardContext = this.getContextBean(StandardContext.class);
            standardContext.setResponse(nodeParam);
        }
    }

    @Override
    public void process() throws Exception {
        LogUtil.info("[BPMN][Main] start...");
    }
}
