package com.elitesland.cbpl.bpmn.domain.constant;

import com.elitesland.cbpl.bpmn.domain.context.GlobalContext;
import com.elitesland.cbpl.bpmn.domain.context.InfinityContext;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.bpmn.domain.context.TransformContext;
import com.yomahub.liteflow.slot.DefaultContext;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/07
 */
public interface BpmnConstant {

    /**
     * 起始节点
     */
    String BPMN_NODE_START = "__start";
    /**
     * 终止节点
     */
    String BPMN_NODE_END = "__end";
    /**
     * 调用接口节点
     */
    String BPMN_NODE_INFINITY = "__infinity";
    /**
     * 数据转换节点
     */
    String BPMN_NODE_TRANSFORM = "__transform";
    /**
     * 迭代器包装节点
     */
    String BPMN_NODE_ITERATOR = "__iterator";
    /**
     * 迭代器遍历节点
     */
    String BPMN_NODE_CURR_LOOP = "__curr_loop";
    /**
     * 工作流节点
     */
    String BPMN_NODE_SCRIPT_WF = "__workflow";

    /**
     * 动态脚本节点
     */
    String BPMN_NODE_SCRIPT_JAVA = "__script_java";
    String BPMN_NODE_SCRIPT_GROOVY = "__script_groovy";
    String BPMN_NODE_SCRIPT_JS = "__script_js";

    static List<Class<?>> bpmnCommonContext() {
        List<Class<?>> context = new ArrayList<>();
        context.add(DefaultContext.class);
        context.add(GlobalContext.class);
        context.add(StandardContext.class);
        context.add(InfinityContext.class);
        context.add(TransformContext.class);
        return context;
    }
}
