/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.data.entity.QTaskDefineDO;
import com.elitesland.cbpl.bpmn.data.entity.QTaskInstanceDO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceDeleteParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstancePagingVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TaskInstanceRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QTaskDefineDO taskDefineDO = QTaskDefineDO.taskDefineDO;
    private static final QTaskInstanceDO taskInstanceDO = QTaskInstanceDO.taskInstanceDO;
    private final QBean<TaskInstancePagingVO> taskInstancePagingVO;

    private Predicate pagingWhere(TaskInstancePagingParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskInstanceRepoProc.taskInstanceDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull((Object)query.getVersion())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.version.eq((Object)query.getVersion()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getInstanceStatus())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.instanceStatus.eq((Object)query.getInstanceStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCurrNodeId())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.currNodeId.eq((Object)query.getCurrNodeId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCurrNodeName())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.currNodeName.eq((Object)query.getCurrNodeName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.errorMessage.eq((Object)query.getErrorMessage()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStartTime())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.startTime.eq((Object)query.getStartTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getEndTime())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.endTime.eq((Object)query.getEndTime()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.remark.eq((Object)query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long taskInstanceCountBy(TaskInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(TaskInstanceRepoProc.taskInstanceDO.id).from((EntityPath)taskInstanceDO)).leftJoin((EntityPath)taskDefineDO)).on((Predicate)TaskInstanceRepoProc.taskDefineDO.taskCode.eq((Expression)TaskInstanceRepoProc.taskInstanceDO.taskCode));
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TaskInstancePagingVO> taskInstancePageBy(TaskInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.taskInstancePagingVO).from((EntityPath)taskInstanceDO)).leftJoin((EntityPath)taskDefineDO)).on((Predicate)TaskInstanceRepoProc.taskDefineDO.taskCode.eq((Expression)TaskInstanceRepoProc.taskInstanceDO.taskCode));
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, taskInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public long update(TaskInstanceSaveParamVO saveParam) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)taskInstanceDO).set(TaskInstanceRepoProc.taskInstanceDO.endTime, (Object)saveParam.getEndTime()).set((Path)TaskInstanceRepoProc.taskInstanceDO.errorMessage, (Object)saveParam.getErrorMessage()).where(new Predicate[]{TaskInstanceRepoProc.taskInstanceDO.id.eq((Object)saveParam.getId())});
        if (StrUtil.isNotBlank((CharSequence)saveParam.getInstanceStatus())) {
            update.set((Path)TaskInstanceRepoProc.taskInstanceDO.instanceStatus, (Object)saveParam.getInstanceStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getRemark())) {
            update.set((Path)TaskInstanceRepoProc.taskInstanceDO.remark, (Object)saveParam.getRemark());
        }
        return update.execute();
    }

    public long delete(TaskInstanceDeleteParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskInstanceRepoProc.taskInstanceDO.taskCode.eq((Object)paramVO.getTaskCode()));
        predicates.add(TaskInstanceRepoProc.taskInstanceDO.instanceStatus.in(paramVO.getInstanceStatus()));
        if (ObjectUtil.isNotNull((Object)paramVO.getBeforeTime())) {
            predicates.add(TaskInstanceRepoProc.taskInstanceDO.startTime.lt((Comparable)paramVO.getBeforeTime()));
        }
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)taskInstanceDO);
        delete.where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public TaskInstanceRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.taskInstancePagingVO = Projections.bean(TaskInstancePagingVO.class, (Expression[])new Expression[]{TaskInstanceRepoProc.taskInstanceDO.id, TaskInstanceRepoProc.taskDefineDO.id.as("masId"), TaskInstanceRepoProc.taskDefineDO.taskName, TaskInstanceRepoProc.taskInstanceDO.taskCode, TaskInstanceRepoProc.taskInstanceDO.version, TaskInstanceRepoProc.taskInstanceDO.instanceStatus, TaskInstanceRepoProc.taskInstanceDO.currNodeId, TaskInstanceRepoProc.taskInstanceDO.currNodeName, TaskInstanceRepoProc.taskInstanceDO.errorMessage, TaskInstanceRepoProc.taskInstanceDO.startTime, TaskInstanceRepoProc.taskInstanceDO.endTime, TaskInstanceRepoProc.taskInstanceDO.remark, TaskInstanceRepoProc.taskInstanceDO.createUserId, TaskInstanceRepoProc.taskInstanceDO.creator, TaskInstanceRepoProc.taskInstanceDO.createTime, TaskInstanceRepoProc.taskInstanceDO.modifyUserId, TaskInstanceRepoProc.taskInstanceDO.updater, TaskInstanceRepoProc.taskInstanceDO.modifyTime, TaskInstanceRepoProc.taskInstanceDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

