/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.data.convert.TaskDefineConvert;
import com.elitesland.cbpl.bpmn.data.entity.TaskDefineDO;
import com.elitesland.cbpl.bpmn.data.repo.TaskDefineRepo;
import com.elitesland.cbpl.bpmn.data.repo.TaskDefineRepoProc;
import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.service.TaskVersionService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskCronPublishVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefinePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineSaveParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefinePagingVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionRespVO;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.bpmn.util.BpmnParamUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.common.constant.PublishStatus;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDefineServiceImpl
implements TaskDefineService {
    private static final Logger logger = LoggerFactory.getLogger(TaskDefineServiceImpl.class);
    private final TaskDefineRepo taskDefineRepo;
    private final TaskDefineRepoProc taskDefineRepoProc;
    private final TaskVersionService taskVersionService;
    @Autowired(required=false)
    private BpmnExecutor bpmnExecutor;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;
    private final ScheduleConfigService scheduleConfigService;

    @Override
    public PagingVO<TaskDefinePagingVO> taskDefinePageBy(TaskDefinePagingParamVO query) {
        long count = this.taskDefineRepoProc.taskDefineCountBy(query);
        if (count > 0L) {
            List<TaskDefinePagingVO> list = this.taskDefineRepoProc.taskDefinePageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<TaskDefineRespVO> taskDefineByParam(TaskDefineQueryParamVO query) {
        return this.taskDefineRepoProc.taskDefineByParam(query);
    }

    @Override
    public TaskDefineDetailVO taskDefineById(Long id) {
        Optional taskDefineDO = this.taskDefineRepo.findById(id);
        if (taskDefineDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return TaskDefineConvert.INSTANCE.doToVO((TaskDefineDO)taskDefineDO.get());
    }

    @Override
    public TaskDefineDetailVO effectiveDefineById(Long id) {
        TaskDefineDetailVO defineVO = this.taskDefineById(id);
        TaskVersionQueryParamVO query = new TaskVersionQueryParamVO();
        query.setMasId(id);
        query.setStatus(PublishStatus.EFFECTIVE.getCode());
        List<TaskVersionRespVO> version = this.taskVersionService.taskVersionByParam(query);
        if (CollUtil.size(version) == 1) {
            defineVO.setVersion(version.get(0).getVersion());
            defineVO.setTaskParam(version.get(0).getTaskParam());
            defineVO.setTaskSpel(version.get(0).getTaskSpel());
        } else {
            if (CollUtil.size(version) > 1) {
                throw PhoenixException.unexpected((String)"\u5b58\u5728\u591a\u4e2a\u751f\u6548\u4e2d\u7684\u7248\u672c");
            }
            logger.warn("[PHOENIX-BPMN] Not Found Effective SpEL.");
        }
        return defineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(TaskDefineSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            TaskDefineDO taskDefineDO = TaskDefineConvert.INSTANCE.saveParamToDO(saveParam);
            taskDefineDO.setStatus(ActiveStatus.ACTIVE.getCode());
            this.taskDefineRepo.save(taskDefineDO);
            return taskDefineDO.getId();
        }
        Optional taskDefineDO = this.taskDefineRepo.findById(saveParam.getId());
        if (taskDefineDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        TaskDefineDO taskDefine = (TaskDefineDO)taskDefineDO.get();
        TaskDefineConvert.INSTANCE.saveParamMergeToDO(saveParam, taskDefine);
        this.taskDefineRepo.save(taskDefine);
        return taskDefine.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusV(Long id) {
        if (ObjectUtil.isNotNull((Object)this.bpmnExecutor)) {
            TaskDefineDetailVO defineVO = this.effectiveDefineById(id);
            if (this.bpmnExecutor.containChain(defineVO.getTaskCode(), defineVO.getVersion())) {
                this.bpmnExecutor.destroy(defineVO.getTaskCode(), defineVO.getVersion());
            }
            if (defineVO.existsVersion()) {
                this.bpmnExecutor.register(defineVO.getTaskCode(), defineVO.getVersion(), defineVO.getTaskSpel());
            }
        }
        return this.taskDefineRepoProc.updateStatus(id, ActiveStatus.ACTIVE.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusX(Long id) {
        TaskDefineDetailVO defineVO;
        if (ObjectUtil.isNotNull((Object)this.bpmnExecutor) && this.bpmnExecutor.containChain((defineVO = this.effectiveDefineById(id)).getTaskCode(), defineVO.getVersion())) {
            this.bpmnExecutor.destroy(defineVO.getTaskCode(), defineVO.getVersion());
        }
        return this.taskDefineRepoProc.updateStatus(id, ActiveStatus.INACTIVE.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(List<Long> ids) {
        return this.taskDefineRepoProc.updateDeleteFlag(ids);
    }

    @Override
    public boolean cronPublish(TaskCronPublishVO saveParam) {
        if (ObjectUtil.isNull((Object)this.schedulingRegistrar)) {
            logger.error("[PHOENIX-BPMN] Schedule Not Initialize.");
            throw new RuntimeException("[PHOENIX-BPMN] Schedule Not Initialize.");
        }
        TaskDefineDetailVO defineVO = this.taskDefineById(saveParam.getTaskId());
        if (this.schedulingRegistrar.hasTask(defineVO.getTaskCode())) {
            logger.warn("[PHOENIX-BPMN] TaskCode({}) Registered.", (Object)defineVO.getTaskCode());
            throw new RuntimeException("[PHOENIX-BPMN] TaskCode(" + defineVO.getTaskCode() + ") Registered.");
        }
        ScheduleConfigSaveParamVO saveParamVO = BpmnParamUtil.bpmnParamInit(defineVO.getTaskCode(), defineVO.getTaskName(), saveParam.getCron());
        this.scheduleConfigService.save(saveParamVO);
        return true;
    }

    public TaskDefineServiceImpl(TaskDefineRepo taskDefineRepo, TaskDefineRepoProc taskDefineRepoProc, TaskVersionService taskVersionService, ScheduleConfigService scheduleConfigService) {
        this.taskDefineRepo = taskDefineRepo;
        this.taskDefineRepoProc = taskDefineRepoProc;
        this.taskVersionService = taskVersionService;
        this.scheduleConfigService = scheduleConfigService;
    }
}

