/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.registrar.task;

import com.elitesland.cbpl.bpmn.config.BpmnProperties;
import com.elitesland.cbpl.bpmn.data.service.TaskDefineService;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskDefineQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstanceDeleteParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskDefineRespVO;
import com.elitesland.cbpl.common.constant.PublishStatus;
import com.elitesland.cbpl.scheduling.constant.InstanceStatus;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.spi.SchedulingDeletionSpi;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingParamUtil;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnicomTag(value="__BpmnInstanceDeletionTask")
public class BpmnInstanceDeletionTask
implements SchedulingRegistrarSpi,
SchedulingDeletionSpi {
    private static final Logger logger = LoggerFactory.getLogger(BpmnInstanceDeletionTask.class);
    private final TaskDefineService defineService;
    private final TaskInstanceService instanceService;

    public boolean autoRegister() {
        return BpmnProperties.BPMN_ENABLED;
    }

    public ScheduleConfigSaveParamVO registerTask() {
        return SchedulingParamUtil.deletionParamInit(this.getClass(), (String)"\u6d41\u7a0b\u7f16\u6392\u5b9e\u4f8b-\u5b9a\u65f6\u5220\u9664", (String)BpmnProperties.BPMN_DELETION_CRON);
    }

    public void deletion() {
        TaskDefineQueryParamVO query = new TaskDefineQueryParamVO();
        query.setVersionStatus(PublishStatus.EFFECTIVE.getCode());
        List<TaskDefineRespVO> tasks = this.defineService.taskDefineByParam(query);
        for (TaskDefineRespVO task : tasks) {
            if (task.noDeletion()) {
                logger.warn("[PHOENIX-BPMN] {} deletion strategy: {}", (Object)task.getTaskCode(), (Object)task.getDeletionStrategyName());
                continue;
            }
            TaskInstanceDeleteParamVO deleteParam = new TaskInstanceDeleteParamVO();
            deleteParam.setTaskCode(task.getTaskCode());
            deleteParam.setInstanceStatus(List.of(InstanceStatus.COMPLETE.getCode(), InstanceStatus.INTERRUPT.getCode(), InstanceStatus.STOP.getCode()));
            deleteParam.setBeforeTime(SchedulingUtil.minusDays((String)task.getDeletionStrategy()));
            this.instanceService.deleteInstance(deleteParam, "AUTO");
        }
    }

    public BpmnInstanceDeletionTask(TaskDefineService defineService, TaskInstanceService instanceService) {
        this.defineService = defineService;
        this.instanceService = instanceService;
    }
}

