package com.elitesland.cbpl.bpmn.config;

import com.elitesland.cbpl.bpmn.aspect.GlobalDefaultAspect;
import com.elitesland.cbpl.bpmn.data.service.*;
import com.elitesland.cbpl.bpmn.registrar.BpmnInitialize;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.bpmn.registrar.execute.InstanceExecutor;
import com.elitesland.cbpl.bpmn.registrar.task.BpmnInstanceDeletionTask;
import com.elitesland.cbpl.bpmn.registrar.task.BpmnCronTask;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.yomahub.liteflow.aop.ICmpAroundAspect;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2024/03/05
 */
@Slf4j
@Configuration
@EnableConfigurationProperties({BpmnProperties.class, LiteflowProperty.class})
@ConditionalOnProperty(prefix = "liteflow", name = "enable", havingValue = "true")
@RequiredArgsConstructor
public class BpmnAutoConfiguration {

    /**
     * 实例日志调度
     */
    @Bean
    public InstanceExecutor instanceExecutor() {
        return new InstanceExecutor();
    }

    /**
     * 流程调度
     */
    @Bean
    @ConditionalOnClass
    public BpmnExecutor bpmnExecutor(FlowExecutor flowExecutor, InstanceExecutor instanceExecutor) {
        return new BpmnExecutor(flowExecutor, instanceExecutor);
    }

    /**
     * 流程初始化注册
     */
    @Bean
    public BpmnInitialize bpmnInitialize(BpmnExecutor bpmnExecutor) {
        BpmnInitialize bpmnInitialize = new BpmnInitialize(bpmnExecutor);
        logger.info("[BPMN] Initialize finished.");
        return bpmnInitialize;
    }

    /**
     * 全局组件拦截器
     */
    @Bean
    @ConditionalOnMissingBean
    public ICmpAroundAspect globalDefaultAspect() {
        return new GlobalDefaultAspect();
    }

    /**
     * 实例定时删除任务
     */
    @Bean
    @ConditionalOnClass
    public BpmnInstanceDeletionTask bpmnInstanceDeletionTask(
            TaskDefineService defineService, TaskInstanceService instanceService, PipelineService pipelineService) {
        return new BpmnInstanceDeletionTask(defineService, instanceService, pipelineService);
    }

    @Bean
    @ConditionalOnClass
    public BpmnCronTask bpmnCronTask(TaskClientService clientService) {
        return new BpmnCronTask(clientService);
    }
}
