package com.elitesland.cbpl.bpmn.config;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import static com.elitesland.cbpl.bpmn.config.BpmnProperties.BPMN_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/03/05
 */
@Data
@ConfigurationProperties(prefix = BPMN_CONFIG_PREFIX)
public class BpmnProperties implements InitializingBean, EnvironmentAware {

    private Environment environment;
    public static final String BPMN_CONFIG_PREFIX = "cbpl.bpmn";

    /**
     * 实例定时删除任务频率，默认每天凌晨`01:10:00`执行
     */
    private String deletionStrategyCron = "0 10 1 * * ?";

    public static boolean BPMN_ENABLED;
    public static String BPMN_DELETION_CRON;

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 是否启用：默认关闭
        String property = environment.getProperty("liteflow.enable");
        if (StrUtil.isBlank(property)) {
            property = "false";
        }
        BPMN_ENABLED = Boolean.parseBoolean(property);
        BPMN_DELETION_CRON = deletionStrategyCron;
    }
}
