package com.elitesland.cbpl.bpmn.data.controller;

import com.elitesland.cbpl.bpmn.data.convert.TaskInstanceConvert;
import com.elitesland.cbpl.bpmn.data.service.TaskInstanceService;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskInstancePagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.InstanceDetailVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstancePagingVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_SYSLOG_CFG;

/**
 * @author eric.hao
 * @since 2024/05/09
 */
@Slf4j
@Api(tags = "任务流程 - 实例表")
@RestController
@RequestMapping("/bpmn/instance")
@RequiredArgsConstructor
public class TaskInstanceController {

    private final TaskInstanceService taskInstanceService;
    private final PipelineService pipelineService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/list")
    public HttpResult<PagingVO<TaskInstancePagingVO>> list(@RequestBody TaskInstancePagingParamVO query) {
        logger.info("[TaskInstance] query paging param = {}", query);
        return HttpResult.ok(taskInstanceService.taskInstancePageBy(query));
    }

    @ApiOperation(value = "明细分页查询")
    @PostMapping(value = "/details")
    public HttpResult<PagingVO<InstanceDetailVO>> details(@RequestBody TrackDocQueryParamVO query) {
        logger.info("[TaskInstance] details paging param = {}", query);
        var result = LogConfigUtil.supply(() -> {
            var docs = pipelineService.trackDocPageBy(query);
            var records = TaskInstanceConvert.INSTANCE.recordToVO(docs.getRecords());
            return new PagingVO<>(docs.getTotal(), records);
        }, LOG_SYSLOG_CFG);
        return HttpResult.ok(result);
    }
}
