package com.elitesland.cbpl.bpmn.data.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 执行日志详细记录
 *
 * @author eric.hao
 * @since 2024/07/12
 */
@Data
@ApiModel("统一日志记录内容")
public class InstanceDetailVO implements Serializable {

    private static final long serialVersionUID = 6364089909872751213L;

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "链路ID")
    private String traceId;

    @ApiModelProperty(value = "业务记录的日志")
    private String eventMessage;

    @ApiModelProperty(value = "业务记录的参数")
    private String eventParam;

    @ApiModelProperty(value = "错误信息")
    private String errorMessage;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "客户端IP")
    private String addressIp;
}
