package com.elitesland.cbpl.bpmn.data.vo.resp;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.common.constant.DeletionStrategy;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务流程 - 定义表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 定义表")
public class TaskDefineDetailVO {

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "任务编码")
    private String taskCode;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务类型：常规(规则)流程、接口调度流程、审批流程、业务流程")
    private String taskType;

    @ApiModelProperty(value = "状态：0禁用；1启用；")
    private Integer status;

    @ApiModelProperty(value = "实例删除策略")
    private String deletionStrategy;

    public String getDeletionStrategy() {
        return StrUtil.blankToDefault(deletionStrategy, DeletionStrategy.NO_DELETION.getDays());
    }

    @ApiModelProperty(value = "实例删除策略中文")
    @JsonProperty
    public String getDeletionStrategyName() {
        return DeletionStrategy.fromDays(getDeletionStrategy());
    }

    // 版本对应配置

    @ApiModelProperty(value = "版本号")
    private Integer version;

    @ApiModelProperty(value = "全局参数，JSON对象格式字符串")
    private String taskParam;

    @ApiModelProperty(value = "流程编排SpEL表达式")
    private String taskSpel;

    public boolean existsVersion() {
        return ObjectUtil.isNotNull(version);
    }
}
