package com.elitesland.cbpl.bpmn.data.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务流程 - 实例表
 *
 * @author eric.hao
 * @since 2024/05/09
 */
@Data
@ApiModel("任务流程 - 实例表")
public class TaskInstanceDetailVO {

	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	@ApiModelProperty(value = "主表ID")
	private Long masId;

	@ApiModelProperty(value = "任务编码")
	private String taskCode;

	@ApiModelProperty(value = "版本表ID")
	private Long verId;

	@ApiModelProperty(value = "版本号")
	private Integer version;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "当前任务节点ID")
	private String currNodeId;

	@ApiModelProperty(value = "当前任务节点名称")
	private String currNodeName;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "日志链路ID")
	private String traceId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
