package com.elitesland.cbpl.bpmn.spi;

import com.elitesland.cbpl.bpmn.data.vo.resp.TaskInstanceRespVO;

/**
 * @author eric.hao
 * @since 2024/05/11
 */
public interface BpmnCompleteSpi {

    /**
     * 实例执行前的回调方法
     *
     * @param response 实例值
     */
    void start(TaskInstanceRespVO response);

    /**
     * 实例执行完后的回调方法
     *
     * @param response  实例返回值
     * @param throwable 抛出异常（正常执行时，返回null）
     */
    void whenComplete(TaskInstanceRespVO response, Throwable throwable);
}
