/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.controller;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.data.service.TaskClientService;
import com.elitesland.cbpl.bpmn.registrar.execute.BpmnExecutor;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u6d41\u7a0b - \u5ba2\u6237\u7aef\u8c03\u5ea6\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/bpmn/client"})
public class TaskClientController {
    private static final Logger logger = LoggerFactory.getLogger(TaskClientController.class);
    private final TaskClientService taskClientService;
    @Autowired(required=false)
    private BpmnExecutor bpmnExecutor;

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4e00\u6b21")
    @PostMapping(value={"/task/{taskCode}"})
    public HttpResult<?> execute(@PathVariable(value="taskCode") String taskCode, @RequestBody Object paramObj) {
        logger.info("[BPMN] execute taskCode: {}, params: {}", (Object)taskCode, paramObj);
        return this.taskClientService.execute(taskCode, paramObj);
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4e00\u6b21\uff0c\u6307\u5b9a\u7248\u672c")
    @PostMapping(value={"/task/{taskCode}/{version}"})
    public HttpResult<?> executeVersion(@PathVariable(value="taskCode") String taskCode, @PathVariable(value="version") Integer version, @RequestBody Object paramObj) {
        logger.info("[BPMN] execute taskCode: {}, version: {},  params: {}", new Object[]{taskCode, version, paramObj});
        return this.taskClientService.execute(taskCode, version, paramObj);
    }

    @ApiOperation(value="\u6240\u6709\u5df2\u6ce8\u518c\u7684\u6d41\u7a0b")
    @GetMapping(value={"/task/register/all"})
    public HttpResult<?> queryTaskDefineAll() {
        if (ObjectUtil.isNull((Object)this.bpmnExecutor)) {
            logger.warn("[BPMN] BpmnExecutor Unregistered.");
            return HttpResult.notImplemented((String)"BpmnExecutor Unregistered.");
        }
        return HttpResult.ok(this.bpmnExecutor.chainAll());
    }

    public TaskClientController(TaskClientService taskClientService) {
        this.taskClientService = taskClientService;
    }
}

