/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.data.entity.QTaskVersionDO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionPagingParamVO;
import com.elitesland.cbpl.bpmn.data.vo.param.TaskVersionQueryParamVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionPagingVO;
import com.elitesland.cbpl.bpmn.data.vo.resp.TaskVersionRespVO;
import com.elitesland.cbpl.common.constant.PublishStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TaskVersionRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QTaskVersionDO taskVersionDO = QTaskVersionDO.taskVersionDO;
    private final QBean<TaskVersionPagingVO> taskVersionPagingVO;
    private final QBean<TaskVersionRespVO> taskVersionVO;

    private Predicate pagingWhere(TaskVersionPagingParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskVersionRepoProc.taskVersionDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.id.eq((Object)query.getId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.status.eq((Object)query.getStatus()));
        }
        if (ObjectUtil.isNotNull((Object)query.getVersion())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.version.eq((Object)query.getVersion()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.remark.eq((Object)query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long taskVersionCountBy(TaskVersionPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(TaskVersionRepoProc.taskVersionDO.id).from((EntityPath)taskVersionDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TaskVersionPagingVO> taskVersionPageBy(TaskVersionPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.taskVersionPagingVO).from((EntityPath)taskVersionDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, taskVersionDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(TaskVersionQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskVersionRepoProc.taskVersionDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.id.eq((Object)query.getId()));
        }
        if (ObjectUtil.isNotNull((Object)query.getMasId())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.masId.eq((Object)query.getMasId()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.status.eq((Object)query.getStatus()));
        }
        if (ObjectUtil.isNotNull((Object)query.getVersion())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.version.eq((Object)query.getVersion()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(TaskVersionRepoProc.taskVersionDO.remark.eq((Object)query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<TaskVersionRespVO> taskVersionByParam(TaskVersionQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.taskVersionVO).from((EntityPath)taskVersionDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(Long id) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)taskVersionDO).where(new Predicate[]{TaskVersionRepoProc.taskVersionDO.id.eq((Object)id)});
        return delete.execute();
    }

    public long published(Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)taskVersionDO).set(TaskVersionRepoProc.taskVersionDO.status, (Object)PublishStatus.EFFECTIVE.getCode()).where(new Predicate[]{TaskVersionRepoProc.taskVersionDO.id.eq((Object)id)});
        return update.execute();
    }

    public long unPublished(Long id, Long masId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskVersionRepoProc.taskVersionDO.id.ne((Object)id));
        predicates.add(TaskVersionRepoProc.taskVersionDO.masId.eq((Object)masId));
        predicates.add(TaskVersionRepoProc.taskVersionDO.status.eq((Object)PublishStatus.EFFECTIVE.getCode()));
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)taskVersionDO).set(TaskVersionRepoProc.taskVersionDO.status, (Object)PublishStatus.PUBLISHED.getCode()).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return update.execute();
    }

    public int queryMaxVersion(String taskCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskVersionRepoProc.taskVersionDO.deleteFlag.eq((Object)0));
        predicates.add(TaskVersionRepoProc.taskVersionDO.taskCode.eq((Object)taskCode));
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)TaskVersionRepoProc.taskVersionDO.version.max()).from((EntityPath)taskVersionDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        Integer maxVersion = (Integer)jpaQuery.fetchOne();
        return ObjectUtil.isNull((Object)maxVersion) ? 0 : maxVersion;
    }

    public int queryEffectiveVersion(String taskCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TaskVersionRepoProc.taskVersionDO.deleteFlag.eq((Object)0));
        predicates.add(TaskVersionRepoProc.taskVersionDO.taskCode.eq((Object)taskCode));
        predicates.add(TaskVersionRepoProc.taskVersionDO.status.eq((Object)PublishStatus.EFFECTIVE.getCode()));
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)TaskVersionRepoProc.taskVersionDO.version.max()).from((EntityPath)taskVersionDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        Integer maxVersion = (Integer)jpaQuery.fetchOne();
        return ObjectUtil.isNull((Object)maxVersion) ? 0 : maxVersion;
    }

    public TaskVersionRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.taskVersionPagingVO = Projections.bean(TaskVersionPagingVO.class, (Expression[])new Expression[]{TaskVersionRepoProc.taskVersionDO.id, TaskVersionRepoProc.taskVersionDO.masId, TaskVersionRepoProc.taskVersionDO.taskCode, TaskVersionRepoProc.taskVersionDO.status, TaskVersionRepoProc.taskVersionDO.version, TaskVersionRepoProc.taskVersionDO.taskParam, TaskVersionRepoProc.taskVersionDO.taskSpel, TaskVersionRepoProc.taskVersionDO.remark, TaskVersionRepoProc.taskVersionDO.createUserId, TaskVersionRepoProc.taskVersionDO.creator, TaskVersionRepoProc.taskVersionDO.createTime, TaskVersionRepoProc.taskVersionDO.modifyUserId, TaskVersionRepoProc.taskVersionDO.updater, TaskVersionRepoProc.taskVersionDO.modifyTime, TaskVersionRepoProc.taskVersionDO.deleteFlag});
        this.taskVersionVO = Projections.bean(TaskVersionRespVO.class, (Expression[])new Expression[]{TaskVersionRepoProc.taskVersionDO.id, TaskVersionRepoProc.taskVersionDO.masId, TaskVersionRepoProc.taskVersionDO.taskCode, TaskVersionRepoProc.taskVersionDO.status, TaskVersionRepoProc.taskVersionDO.version, TaskVersionRepoProc.taskVersionDO.taskParam, TaskVersionRepoProc.taskVersionDO.taskSpel, TaskVersionRepoProc.taskVersionDO.remark, TaskVersionRepoProc.taskVersionDO.createUserId, TaskVersionRepoProc.taskVersionDO.creator, TaskVersionRepoProc.taskVersionDO.createTime, TaskVersionRepoProc.taskVersionDO.modifyUserId, TaskVersionRepoProc.taskVersionDO.updater, TaskVersionRepoProc.taskVersionDO.modifyTime, TaskVersionRepoProc.taskVersionDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

